/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.items;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class KnifeItem
extends ToolItem {
    public static final ToolType KNIFE_TOOL = ToolType.get((String)"farmersdelight_knife");
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet();

    public KnifeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, properties);
    }

    @Nonnull
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)KNIFE_TOOL);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        if (EFFECTIVE_ON.contains(state.func_177230_c())) {
            return this.field_77864_a;
        }
        return material != Material.field_151580_n && material != Material.field_151593_r && material != Material.field_151568_F && material != Material.field_151569_G ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        ItemStack tool = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Direction facing = context.func_196000_l();
        if (state.func_177230_c() == Blocks.field_150423_aK && ModTags.KNIVES.func_230235_a_((Object)tool.func_77973_b())) {
            PlayerEntity player = context.func_195999_j();
            if (player != null && !world.field_72995_K) {
                Direction direction = facing.func_176740_k() == Direction.Axis.Y ? player.func_174811_aO().func_176734_d() : facing;
                world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)direction), 11);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151080_bb, 4));
                itemEntity.func_213293_j(0.05 * (double)direction.func_82601_c() + world.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)direction.func_82599_e() + world.field_73012_v.nextDouble() * 0.02);
                world.func_217376_c((Entity)itemEntity);
                tool.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        HashSet ALLOWED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n, Enchantments.field_180313_o, Enchantments.field_77334_n, Enchantments.field_185304_p});
        if (ALLOWED_ENCHANTMENTS.contains(enchantment)) {
            return true;
        }
        HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.field_185308_t});
        if (DENIED_ENCHANTMENTS.contains(enchantment)) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class KnifeEvents {
        @SubscribeEvent
        public static void onKnifeKnockback(LivingKnockBackEvent event) {
            ItemStack tool;
            LivingEntity attacker = event.getEntityLiving().func_94060_bK();
            ItemStack itemStack = tool = attacker != null ? attacker.func_184586_b(Hand.MAIN_HAND) : ItemStack.field_190927_a;
            if (tool.func_77973_b() instanceof KnifeItem) {
                float f = event.getOriginalStrength();
                event.setStrength(event.getOriginalStrength() - 0.1f);
            }
        }

        @SubscribeEvent
        public static void onCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = event.getWorld().func_180495_p(pos);
            ItemStack tool = event.getPlayer().func_184586_b(event.getHand());
            if (state.func_177230_c() == Blocks.field_150414_aQ && ModTags.KNIVES.func_230235_a_((Object)tool.func_77973_b())) {
                int bites = (Integer)state.func_177229_b((Property)CakeBlock.field_176589_a);
                if (bites < 6) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    world.func_217377_a(pos, false);
                }
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)ModItems.CAKE_SLICE.get()));
                world.func_184133_a(null, pos, SoundEvents.field_187546_ae, SoundCategory.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

